<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SettingsController extends Controller
{
    /**
     * GET /settings
     */
    public function index()
    {
        $rows = DB::table('settings')->select('key','value')->get();
        $settings = [];
        foreach ($rows as $r) { $settings[$r->key] = $r->value; }
        return response()->json(['settings' => $settings]);
    }

    /**
     * PUT /settings
     * Body: { key: value, ... }
     */
    public function update(Request $request)
    {
        $data = $request->all();
        foreach ($data as $key => $value) {
            DB::table('settings')->updateOrInsert(
                ['key' => $key],
                ['value' => is_scalar($value) ? (string)$value : json_encode($value), 'updated_at' => now()]
            );
        }
        return response()->json(['ok' => true]);
    }
}
