<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class StudentController extends Controller
{
    /**
     * Resolve a student by QR UID.
     */
    public function resolve(string $qr_uid)
    {
        $student = DB::table('students')
            ->join('grades', 'students.grade_id', '=', 'grades.id')
            ->select(
                'students.id', 'students.uid', 'students.first_name', 'students.last_name',
                'students.qr_uid', 'students.status',
                'grades.id as grade_id', 'grades.name as grade_name'
            )
            ->where('students.qr_uid', $qr_uid)
            ->first();

        if (!$student) {
            return response()->json(['error' => ['code' => 'NOT_FOUND', 'message' => 'Student not found']], 404);
        }

        return response()->json(['student' => $student]);
    }
}
