<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class DevicesWebController extends Controller
{
    public function index()
    {
        $devices = DB::table('devices')
            ->select('id','name','api_token','last_seen_at','created_at')
            ->orderBy('created_at','desc')
            ->paginate(15);
        return view('devices.index', [ 'devices' => $devices ]);
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'nullable|string|max:150',
        ]);
        $token = Str::random(40);
        $id = DB::table('devices')->insertGetId([
            'name' => $data['name'] ?? null,
            'api_token' => hash('sha256', $token),
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        return redirect()->route('devices.index')
            ->with('ok', 'Device registered')
            ->with('new_token', $token);
    }

    public function resetToken(int $id)
    {
        $exists = DB::table('devices')->where('id',$id)->exists();
        if (!$exists) { abort(404); }
        $token = Str::random(40);
        DB::table('devices')->where('id',$id)->update([
            'api_token' => hash('sha256', $token),
            'updated_at' => now(),
        ]);
        return redirect()->route('devices.index')
            ->with('ok', 'Device token reset. Provide new token to gatekeeper app.')
            ->with('new_token', $token);
    }

    public function destroy(int $id)
    {
        DB::table('devices')->where('id',$id)->delete();
        return redirect()->route('devices.index')->with('ok', 'Device deleted');
    }
}
