@extends('layouts.app')

@section('title','Devices')

@section('content')
<div class="card">
  <div class="card-header" style="display:flex; align-items:center; justify-content:space-between; gap:10px; flex-wrap:wrap;">
    <div>Registered Devices</div>
    <form method="POST" action="{{ route('devices.store') }}" style="display:flex; gap:8px; align-items:center;">
      @csrf
      <input type="text" name="name" placeholder="Device name (optional)" style="padding:8px 10px; border-radius:8px; border:1px solid #cfd8dc;">
      <button class="btn" type="submit">Register Device</button>
    </form>
  </div>
  <div class="card-body" style="overflow-x:auto;">
    @if (session('ok'))
      <div style="margin-bottom:12px; padding:10px 12px; border-radius:10px; background:rgba(13,71,161,0.08); color:#0D47A1;">
        {{ session('ok') }}
      </div>
    @endif
    @if (session('new_token'))
      <div style="margin-bottom:12px; padding:10px 12px; border-radius:10px; background:rgba(255,235,59,0.2); color:#795548;">
        <div style="display:flex; align-items:center; gap:8px; flex-wrap:wrap;">
          <strong>New Device Token:</strong>
          <code id="new-device-token">{{ session('new_token') }}</code>
          <button type="button" class="btn" onclick="copyToken()">Copy</button>
        </div>
        <div class="muted">Copy now and provide to the gatekeeper app. It will be hashed in storage and not shown again.</div>
      </div>
      <script>
        function copyToken() {
          const el = document.getElementById('new-device-token');
          if (!el) return;
          const text = el.textContent || el.innerText;
          navigator.clipboard.writeText(text).then(() => {
            alert('Token copied to clipboard');
          }).catch(() => {
            // Fallback for browsers without clipboard API
            const t = document.createElement('textarea');
            t.value = text; document.body.appendChild(t); t.select();
            try { document.execCommand('copy'); alert('Token copied to clipboard'); } catch(e){}
            document.body.removeChild(t);
          });
        }
      </script>
    @endif

    @if ($devices->count() === 0)
      <p>No devices found.</p>
    @else
      <table>
        <thead>
          <tr>
            <th>Name</th>
            <th>API Token (hash)</th>
            <th>Last Seen</th>
            <th>Registered</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          @foreach ($devices as $d)
            <tr>
              <td>{{ $d->name ?? 'Unnamed' }}</td>
              <td><code>{{ \Illuminate\Support\Str::limit($d->api_token, 16) }}</code></td>
              <td>{{ $d->last_seen_at ? \Carbon\Carbon::parse($d->last_seen_at)->diffForHumans() : '-' }}</td>
              <td>{{ \Carbon\Carbon::parse($d->created_at)->format('Y-m-d H:i') }}</td>
              <td>
                <div style="display:flex; gap:8px;">
                  <form method="POST" action="{{ route('devices.reset_token', $d->id) }}" onsubmit="return confirm('Reset this device token?');">
                    @csrf
                    <button class="btn" type="submit">Reset Token</button>
                  </form>
                  <form method="POST" action="{{ route('devices.destroy', $d->id) }}" onsubmit="return confirm('Delete this device?');">
                    @csrf
                    <button class="btn secondary" type="submit" style="background:#D32F2F;">Delete</button>
                  </form>
                </div>
              </td>
            </tr>
          @endforeach
        </tbody>
      </table>
      <div style="margin-top:12px;">{{ $devices->links() }}</div>
    @endif
  </div>
</div>
@endsection
