@extends('layouts.app')

@section('title','Edit Student')

@section('content')
<div class="card">
  <div class="card-header">Edit Student</div>
  <div class="card-body">
    @if ($errors->any())
      <div style="margin-bottom:12px; padding:10px 12px; border-radius:10px; background:rgba(211,47,47,0.08); color:#C62828;">
        <strong>Fix the errors below:</strong>
        <ul>
          @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
          @endforeach
        </ul>
      </div>
    @endif

    <form method="POST" action="{{ route('students.update', $student->id) }}">
      @csrf
      <div style="display:grid; grid-template-columns: repeat(2, minmax(0,1fr)); gap:12px;">
        <div>
          <label>First Name</label>
          <input type="text" name="first_name" value="{{ old('first_name', $student->first_name) }}" required style="width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc;">
        </div>
        <div>
          <label>Last Name</label>
          <input type="text" name="last_name" value="{{ old('last_name', $student->last_name) }}" required style="width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc;">
        </div>
        <div>
          <label>Gender</label>
          <select name="gender" required style="width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc;">
            <option value="">Select...</option>
            <option value="Male" {{ old('gender', $student->gender)=='Male'?'selected':'' }}>Male</option>
            <option value="Female" {{ old('gender', $student->gender)=='Female'?'selected':'' }}>Female</option>
          </select>
        </div>
        <div>
          <label>Grade</label>
          <select name="grade_id" required style="width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc;">
            <option value="">Select...</option>
            @foreach ($grades as $g)
              <option value="{{ $g->id }}" {{ old('grade_id', $student->grade_id)==$g->id?'selected':'' }}>{{ $g->name }}</option>
            @endforeach
          </select>
        </div>
        <div>
          <label>Parent Full Name</label>
          <input type="text" name="parent_full_name" value="{{ old('parent_full_name', $parent->full_name ?? '') }}" required style="width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc;">
        </div>
        <div>
          <label>Parent WhatsApp</label>
          <input type="text" name="parent_whatsapp" value="{{ old('parent_whatsapp', $parent->whatsapp_number ?? '') }}" required style="width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc;">
        </div>
        <div>
          <label>Parent Email (optional)</label>
          <input type="email" name="parent_email" value="{{ old('parent_email', $parent->email ?? '') }}" style="width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc;">
        </div>
        <div>
          <label>Status</label>
          <input type="text" name="status" value="{{ old('status', $student->status) }}" style="width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc;">
        </div>
      </div>
      <div style="margin-top:16px; display:flex; gap:10px;">
        <button class="btn" type="submit">Update</button>
        <a class="btn secondary" href="{{ route('students.index') }}" style="background:#90A4AE;">Cancel</a>
      </div>
    </form>
  </div>
</div>
@endsection
