<?php $__env->startSection('title','Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="card" style="margin-bottom:16px;">
  <div class="card-header">Overview</div>
  <div class="card-body">
    <div style="display:grid; grid-template-columns: repeat(auto-fit, minmax(160px, 1fr)); gap:12px;">
      <div style="background:linear-gradient(135deg, rgba(13,71,161,0.12), rgba(13,71,161,0.05)); border:1px solid rgba(13,71,161,0.15); border-radius:14px; padding:16px;">
        <div class="muted">Total Students</div>
        <div style="font-size:28px; font-weight:700; color:#0D47A1;"><?php echo e($metrics['total_students'] ?? '-'); ?></div>
      </div>
      <div style="background:linear-gradient(135deg, rgba(76,175,80,0.12), rgba(76,175,80,0.05)); border:1px solid rgba(76,175,80,0.15); border-radius:14px; padding:16px;">
        <div class="muted">Active Students</div>
        <div style="font-size:28px; font-weight:700; color:#388E3C;"><?php echo e($metrics['active_students'] ?? '-'); ?></div>
      </div>
      <div style="background:linear-gradient(135deg, rgba(66,165,245,0.12), rgba(66,165,245,0.05)); border:1px solid rgba(66,165,245,0.15); border-radius:14px; padding:16px;">
        <div class="muted">Present Today</div>
        <div style="font-size:28px; font-weight:700; color:#1565C0;"><?php echo e($metrics['present_today'] ?? '-'); ?></div>
      </div>
      <div style="background:linear-gradient(135deg, rgba(255,152,0,0.12), rgba(255,152,0,0.05)); border:1px solid rgba(255,152,0,0.15); border-radius:14px; padding:16px;">
        <div class="muted">Late Today</div>
        <div style="font-size:28px; font-weight:700; color:#EF6C00;"><?php echo e($metrics['late_today'] ?? '-'); ?></div>
      </div>
      <div style="background:linear-gradient(135deg, rgba(211,47,47,0.12), rgba(211,47,47,0.05)); border:1px solid rgba(211,47,47,0.15); border-radius:14px; padding:16px;">
        <div class="muted">Messages Today</div>
        <div style="font-size:28px; font-weight:700; color:#C62828;"><?php echo e($metrics['messages_today'] ?? '-'); ?></div>
      </div>
    </div>
  </div>
  </div>

  <div class="card">
    <div class="card-header">Quick Actions</div>
    <div class="card-body" style="display:flex; gap:10px; flex-wrap:wrap;">
      <a class="btn" href="/students">View Students</a>
      <a class="btn" href="/students/create">Add Student</a>
      <a class="btn" href="/students/qr">Print QRs</a>
      <a class="btn" href="/reports">View Reports</a>
      <a class="btn" href="/settings">Settings</a>
    </div>
  </div>

  <div class="card" style="margin-top:16px;">
    <div class="card-header">Latest Activity</div>
    <div class="card-body" style="overflow-x:auto;">
      <?php if(($latest ?? collect())->count() === 0): ?>
        <p class="muted">No recent activity.</p>
      <?php else: ?>
        <table>
          <thead>
            <tr>
              <th>Student</th>
              <th>Grade</th>
              <th>Type</th>
              <th>Time</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $latest; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($row->last_name); ?>, <?php echo e($row->first_name); ?></td>
                <td><?php echo e($row->grade_name); ?></td>
                <td>
                  <span style="padding:4px 8px; border-radius:6px; font-size:12px; font-weight:600; <?php echo e($row->type==='in' ? 'background:rgba(76,175,80,0.1); color:#388E3C;' : 'background:rgba(211,47,47,0.1); color:#C62828;'); ?>">
                    <?php echo e(strtoupper($row->type)); ?>

                  </span>
                </td>
                <td><?php echo e(date('Y-m-d H:i', strtotime($row->occurred_at))); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      <?php endif; ?>
    </div>
  </div>

  <p class="muted" style="margin-top:10px;">Environment: <?php echo e(config('app.env')); ?> | Time: <?php echo e(now()->format('Y-m-d H:i')); ?></p>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\TemitopeNejo\OneDrive - Puroclean Home Savers\Documents\Attendance\backend_app\resources\views/dashboard.blade.php ENDPATH**/ ?>