<?php $__env->startSection('title','Print QR Codes'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
  <div class="card-header" style="display:flex; align-items:center; justify-content:space-between;">
    <div>QR Codes</div>
    <div>
      <button class="btn" onclick="window.print()">Print</button>
    </div>
  </div>
  <div class="card-body">
    <form method="GET" action="<?php echo e(route('students.qr')); ?>" style="margin-bottom:16px; display:flex; gap:10px; align-items:center; flex-wrap:wrap;">
      <label>Filter by Grade</label>
      <select name="grade_id" style="padding:8px 10px; border-radius:8px; border:1px solid #cfd8dc;">
        <option value="">All Grades</option>
        <?php $__currentLoopData = $grades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($g->id); ?>" <?php echo e((string)$selectedGradeId === (string)$g->id ? 'selected' : ''); ?>><?php echo e($g->name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
      <label style="display:inline-flex; gap:6px; align-items:center;">
        <input type="checkbox" name="group" value="1" <?php echo e($group ? 'checked' : ''); ?>> Group by grade
      </label>
      <button class="btn" type="submit">Apply</button>
    </form>

    <?php if($students->count() === 0): ?>
      <p>No students found for this filter.</p>
    <?php else: ?>
      <?php if($group): ?>
        <?php $byGrade = collect($students)->groupBy('grade_name'); ?>
        <?php $__currentLoopData = $byGrade; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gradeName => $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <h3 style="margin:12px 0; color:#0D47A1;"><?php echo e($gradeName); ?></h3>
          <div class="qr-grid" style="display:grid; grid-template-columns: repeat(3, minmax(0,1fr)); gap:16px;">
            <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="qr-card" style="background:#fff; border:1px solid #eee; border-radius:12px; padding:14px; display:flex; gap:12px; align-items:center;">
                <div class="qr-box" id="qr-<?php echo e($loop->parent->index); ?>-<?php echo e($loop->index); ?>" data-qr="<?php echo e($s->qr_uid); ?>" style="width:110px; height:110px; display:flex; align-items:center; justify-content:center; border:1px dashed #ddd; border-radius:10px;"></div>
                <div style="flex:1;">
                  <div style="font-weight:700; color:#0D47A1;"><?php echo e($s->last_name); ?>, <?php echo e($s->first_name); ?></div>
                  <div class="muted"><?php echo e($s->grade_name); ?></div>
                  <div class="muted"><code style="font-size:12px;"><?php echo e($s->qr_uid); ?></code></div>
                  <div style="margin-top:8px; display:flex; align-items:center; gap:8px;">
                    <img src="/assets/brand/logo.png" alt="Logo" style="height:20px; width:auto;" />
                    <span class="muted">CPS Attendance</span>
                  </div>
                </div>
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      <?php else: ?>
        <div class="qr-grid" style="display:grid; grid-template-columns: repeat(3, minmax(0,1fr)); gap:16px;">
          <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="qr-card" style="background:#fff; border:1px solid #eee; border-radius:12px; padding:14px; display:flex; gap:12px; align-items:center;">
              <div class="qr-box" id="qr-<?php echo e($loop->index); ?>" data-qr="<?php echo e($s->qr_uid); ?>" style="width:110px; height:110px; display:flex; align-items:center; justify-content:center; border:1px dashed #ddd; border-radius:10px;"></div>
              <div style="flex:1;">
                <div style="font-weight:700; color:#0D47A1;"><?php echo e($s->last_name); ?>, <?php echo e($s->first_name); ?></div>
                <div class="muted"><?php echo e($s->grade_name); ?></div>
                <div class="muted"><code style="font-size:12px;"><?php echo e($s->qr_uid); ?></code></div>
                <div style="margin-top:8px; display:flex; align-items:center; gap:8px;">
                  <img src="/assets/brand/logo.png" alt="Logo" style="height:20px; width:auto;" />
                  <span class="muted">CPS Attendance</span>
                </div>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      <?php endif; ?>
    <?php endif; ?>
  </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
<script>
  document.addEventListener('DOMContentLoaded', function(){
    function renderQRCodes(){
      if (typeof QRCode === 'undefined') return false;
      document.querySelectorAll('.qr-box').forEach(function(el){
        const val = el.getAttribute('data-qr');
        try {
          new QRCode(el, { text: val, width: 100, height: 100 });
        } catch (e) { console.error('QR render error', e); }
      });
      return true;
    }
    // Try first load
    if (!renderQRCodes()) {
      // Fallback: load from jsDelivr
      var s = document.createElement('script');
      s.src = 'https://cdn.jsdelivr.net/npm/qrcodejs@1.0.0/qrcode.min.js';
      s.onload = renderQRCodes;
      document.body.appendChild(s);
    }
  });
</script>

<style>
  @media print {
    body { background: #fff; }
    .sidebar, .topbar, form, .card-header button { display:none !important; }
    .container { padding:0; }
    .qr-grid { grid-template-columns: repeat(3, minmax(0,1fr)); gap:12px; }
    .qr-card { page-break-inside: avoid; border:1px solid #ccc; }
  }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\TemitopeNejo\OneDrive - Puroclean Home Savers\Documents\Attendance\backend_app\resources\views/students/qr.blade.php ENDPATH**/ ?>