<?php $__env->startSection('title','Attendance Reports'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
  <div class="card-header" style="display:flex; align-items:center; justify-content:space-between;">
    <div>Attendance Report</div>
    <a class="btn" href="<?php echo e(route('reports.export', ['date' => $date, 'grade_id' => $selectedGradeId])); ?>">Export CSV</a>
  </div>
  <div class="card-body" style="overflow-x:auto;">
    <form method="GET" action="<?php echo e(route('reports.index')); ?>" style="margin-bottom:16px; display:flex; gap:12px; align-items:center; flex-wrap:wrap;">
      <div>
        <label>Date</label>
        <input type="date" name="date" value="<?php echo e($date); ?>" style="padding:8px 10px; border-radius:8px; border:1px solid #cfd8dc;">
      </div>
      <div>
        <label>Grade</label>
        <select name="grade_id" style="padding:8px 10px; border-radius:8px; border:1px solid #cfd8dc;">
          <option value="">All Grades</option>
          <?php $__currentLoopData = $grades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($g->id); ?>" <?php echo e((string)$selectedGradeId === (string)$g->id ? 'selected' : ''); ?>><?php echo e($g->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <button class="btn" type="submit">Apply</button>
    </form>

    <?php
      $present = collect($attendanceData)->where('status', '!=', 'Absent')->count();
      $absent = collect($attendanceData)->where('status', 'Absent')->count();
      $late = collect($attendanceData)->filter(fn($a) => str_contains($a['status'], 'Late'))->count();
      $total = count($attendanceData);
      $byGrade = collect($attendanceData)->groupBy(fn($a) => $a['student']->grade_name ?? 'Unassigned')
                  ->map(function($items){
                    $p = $items->where('status','!=','Absent')->count();
                    $l = $items->filter(fn($a)=> str_contains($a['status'],'Late'))->count();
                    $t = $items->count();
                    return ['present'=>$p,'late'=>$l,'total'=>$t];
                  });
    ?>

    <?php if($total === 0): ?>
      <p>No students found for this filter.</p>
    <?php else: ?>
      <div style="margin-bottom:16px; display:flex; flex-direction:column; gap:10px;">
        <div style="display:flex; gap:12px; align-items:center; flex-wrap:wrap;">
          <span style="font-weight:700;">Summary (<?php echo e($date); ?>):</span>
          <span style="padding:4px 8px; border-radius:8px; background:rgba(76,175,80,0.1); color:#388E3C;">Present: <?php echo e($present); ?>/<?php echo e($total); ?></span>
          <span style="padding:4px 8px; border-radius:8px; background:rgba(255,152,0,0.1); color:#F57C00;">Late: <?php echo e($late); ?></span>
          <span style="padding:4px 8px; border-radius:8px; background:rgba(211,47,47,0.1); color:#C62828;">Absent: <?php echo e($absent); ?></span>
        </div>
        <div style="display:flex; gap:8px; flex-wrap:wrap;">
          <?php $__currentLoopData = $byGrade; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grade => $vals): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('reports.index', ['date'=>$date,'grade_id'=>optional($grades->firstWhere('name',$grade))->id])); ?>" style="text-decoration:none;">
              <span style="display:inline-flex; align-items:center; gap:6px; padding:6px 10px; border-radius:999px; border:1px solid #e0e0e0; background:#fff;">
                <strong style="color:#0D47A1;"><?php echo e($grade); ?></strong>
                <span class="muted"><?php echo e($vals['present']); ?>/<?php echo e($vals['total']); ?> present</span>
              </span>
            </a>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>

      <div style="display:grid; grid-template-columns: repeat(auto-fit, minmax(260px, 1fr)); gap:16px; margin-bottom:16px;">
        <div class="card" style="box-shadow:none;">
          <div class="card-header">Status Distribution</div>
          <div class="card-body"><canvas id="statusChart" height="180"></canvas></div>
        </div>
        <div class="card" style="box-shadow:none;">
          <div class="card-header">Present by Grade</div>
          <div class="card-body"><canvas id="gradeChart" height="180"></canvas></div>
        </div>
      </div>

      <table>
        <thead>
          <tr>
            <th>Student</th>
            <th>Grade</th>
            <th>Clock In</th>
            <th>Clock Out</th>
            <th>Status</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $attendanceData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td><?php echo e($data['student']->last_name); ?>, <?php echo e($data['student']->first_name); ?></td>
              <td><?php echo e($data['student']->grade_name); ?></td>
              <td>
                <?php if($data['clock_in']): ?>
                  <?php echo e(date('H:i', strtotime($data['clock_in']->occurred_at))); ?>

                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
              <td>
                <?php if($data['clock_out']): ?>
                  <?php echo e(date('H:i', strtotime($data['clock_out']->occurred_at))); ?>

                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
              <td>
                <span style="
                  padding:4px 8px; 
                  border-radius:6px; 
                  font-size:12px; 
                  font-weight:600;
                  <?php if($data['status'] === 'Absent'): ?> background:rgba(211,47,47,0.1); color:#C62828;
                  <?php elseif(str_contains($data['status'], 'Late')): ?> background:rgba(255,152,0,0.1); color:#F57C00;
                  <?php else: ?> background:rgba(76,175,80,0.1); color:#388E3C; <?php endif; ?>
                ">
                  <?php echo e($data['status']); ?>

                </span>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    <?php endif; ?>
  </div>
</div>

<?php if($total ?? 0): ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
  document.addEventListener('DOMContentLoaded', function(){
    const statusCtx = document.getElementById('statusChart');
    if (statusCtx) {
      new Chart(statusCtx, {
        type: 'doughnut',
        data: {
          labels: ['Present','Late','Absent'],
          datasets: [{
            data: [<?php echo e($present); ?>, <?php echo e($late); ?>, <?php echo e($absent); ?>],
            backgroundColor: ['#4CAF50','#FF9800','#D32F2F']
          }]
        },
        options: { plugins: { legend: { position: 'bottom' } } }
      });
    }
    const gradeCtx = document.getElementById('gradeChart');
    if (gradeCtx) {
      const labels = <?php echo json_encode($byGrade->keys()->values()); ?>;
      const presentData = <?php echo json_encode($byGrade->map(fn($v)=>$v['present'])->values()); ?>;
      new Chart(gradeCtx, {
        type: 'bar',
        data: {
          labels: labels,
          datasets: [{ label: 'Present', data: presentData, backgroundColor: '#0D47A1' }]
        },
        options: { scales: { y: { beginAtZero: true } } }
      });
    }
  });
  </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\TemitopeNejo\OneDrive - Puroclean Home Savers\Documents\Attendance\backend_app\resources\views/reports/index.blade.php ENDPATH**/ ?>