<?php $__env->startSection('title','Add Student'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
  <div class="card-header">Add Student</div>
  <div class="card-body">
    <?php if($errors->any()): ?>
      <div style="margin-bottom:12px; padding:10px 12px; border-radius:10px; background:rgba(211,47,47,0.08); color:#C62828;">
        <strong>Fix the errors below:</strong>
        <ul>
          <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
      </div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('students.store')); ?>">
      <?php echo csrf_field(); ?>
      <div style="display:grid; grid-template-columns: repeat(2, minmax(0,1fr)); gap:12px;">
        <div>
          <label>First Name</label>
          <input type="text" name="first_name" value="<?php echo e(old('first_name')); ?>" required style="width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc;">
        </div>
        <div>
          <label>Last Name</label>
          <input type="text" name="last_name" value="<?php echo e(old('last_name')); ?>" required style="width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc;">
        </div>
        <div>
          <label>Gender</label>
          <select name="gender" required style="width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc;">
            <option value="">Select...</option>
            <option value="Male" <?php echo e(old('gender')=='Male'?'selected':''); ?>>Male</option>
            <option value="Female" <?php echo e(old('gender')=='Female'?'selected':''); ?>>Female</option>
          </select>
        </div>
        <div>
          <label>Grade</label>
          <select name="grade_id" required style="width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc;">
            <option value="">Select...</option>
            <?php $__currentLoopData = $grades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($g->id); ?>" <?php echo e(old('grade_id')==$g->id?'selected':''); ?>><?php echo e($g->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>
        <div>
          <label>Parent Full Name</label>
          <input type="text" name="parent_full_name" value="<?php echo e(old('parent_full_name')); ?>" required style="width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc;">
        </div>
        <div>
          <label>Parent WhatsApp</label>
          <input type="text" name="parent_whatsapp" value="<?php echo e(old('parent_whatsapp')); ?>" required style="width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc;">
        </div>
        <div>
          <label>Parent Email (optional)</label>
          <input type="email" name="parent_email" value="<?php echo e(old('parent_email')); ?>" style="width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc;">
        </div>
        <div>
          <label>Status</label>
          <input type="text" name="status" value="<?php echo e(old('status','active')); ?>" style="width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc;">
        </div>
      </div>
      <div style="margin-top:16px; display:flex; gap:10px;">
        <button class="btn" type="submit">Save</button>
        <a class="btn secondary" href="<?php echo e(route('students.index')); ?>" style="background:#90A4AE;">Cancel</a>
      </div>
    </form>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\TemitopeNejo\OneDrive - Puroclean Home Savers\Documents\Attendance\backend_app\resources\views/students/create.blade.php ENDPATH**/ ?>