<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('messages', function (Blueprint $table) {
            $table->id();
            $table->string('twilio_sid')->nullable()->index();
            $table->string('direction'); // outbound, inbound
            $table->string('channel')->default('whatsapp');
            $table->string('to_number')->nullable();
            $table->string('status')->default('queued');
            $table->json('payload')->nullable();
            $table->foreignId('student_id')->nullable()->constrained('students');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('messages');
    }
};
