<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('message_templates', function (Blueprint $table) {
            if (!Schema::hasColumn('message_templates', 'key')) {
                $table->string('key')->unique();
            }
            if (!Schema::hasColumn('message_templates', 'body')) {
                $table->text('body');
            }
            if (!Schema::hasColumn('message_templates', 'locale')) {
                $table->string('locale')->default('en');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('message_templates', function (Blueprint $table) {
            if (Schema::hasColumn('message_templates', 'locale')) {
                $table->dropColumn('locale');
            }
            if (Schema::hasColumn('message_templates', 'body')) {
                $table->dropColumn('body');
            }
            if (Schema::hasColumn('message_templates', 'key')) {
                $table->dropUnique('message_templates_key_unique');
                $table->dropColumn('key');
            }
        });
    }
};
