<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('parent_contacts', function (Blueprint $table) {
            if (!Schema::hasColumn('parent_contacts', 'full_name')) {
                $table->string('full_name');
            }
            if (!Schema::hasColumn('parent_contacts', 'whatsapp_number')) {
                $table->string('whatsapp_number');
            }
            if (!Schema::hasColumn('parent_contacts', 'email')) {
                $table->string('email')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('parent_contacts', function (Blueprint $table) {
            if (Schema::hasColumn('parent_contacts', 'email')) {
                $table->dropColumn('email');
            }
            if (Schema::hasColumn('parent_contacts', 'whatsapp_number')) {
                $table->dropColumn('whatsapp_number');
            }
            if (Schema::hasColumn('parent_contacts', 'full_name')) {
                $table->dropColumn('full_name');
            }
        });
    }
};
