<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $email = 'admin@cps.local';
        $name = 'Administrator';
        $tempPassword = 'TempCPS!2025';

        $exists = DB::table('users')->where('email', $email)->exists();
        if (!$exists) {
            DB::table('users')->insert([
                'name' => $name,
                'email' => $email,
                'password' => Hash::make($tempPassword),
                'remember_token' => 'CHANGE_PASSWORD_ON_FIRST_LOGIN',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
