<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MessageTemplatesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $templates = [
            [
                'key' => 'clock_in',
                'body' => '[Chalcedony Prime School] {{first_name}} {{last_name}} (Grade {{grade}}) arrived on {{date}} at {{time}}.',
                'locale' => 'en',
            ],
            [
                'key' => 'clock_out',
                'body' => '[Chalcedony Prime School] {{first_name}} {{last_name}} (Grade {{grade}}) departed on {{date}} at {{time}}.',
                'locale' => 'en',
            ],
        ];

        foreach ($templates as $tpl) {
            DB::table('message_templates')->updateOrInsert(
                ['key' => $tpl['key']],
                [
                    'body' => $tpl['body'],
                    'locale' => $tpl['locale'],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]
            );
        }
    }
}
