<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('students', function (Blueprint $table) {
            if (!Schema::hasColumn('students', 'uid')) {
                $table->uuid('uid')->unique();
            }
            if (!Schema::hasColumn('students', 'first_name')) {
                $table->string('first_name');
            }
            if (!Schema::hasColumn('students', 'last_name')) {
                $table->string('last_name');
            }
            if (!Schema::hasColumn('students', 'gender')) {
                $table->enum('gender', ['Male', 'Female']);
            }
            if (!Schema::hasColumn('students', 'grade_id')) {
                $table->foreignId('grade_id')->constrained('grades');
            }
            if (!Schema::hasColumn('students', 'parent_contact_id')) {
                $table->foreignId('parent_contact_id')->constrained('parent_contacts');
            }
            if (!Schema::hasColumn('students', 'qr_uid')) {
                $table->uuid('qr_uid')->unique();
            }
            if (!Schema::hasColumn('students', 'status')) {
                $table->string('status')->default('active');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('students', function (Blueprint $table) {
            if (Schema::hasColumn('students', 'status')) { $table->dropColumn('status'); }
            if (Schema::hasColumn('students', 'qr_uid')) { $table->dropUnique('students_qr_uid_unique'); $table->dropColumn('qr_uid'); }
            if (Schema::hasColumn('students', 'parent_contact_id')) { $table->dropConstrainedForeignId('parent_contact_id'); }
            if (Schema::hasColumn('students', 'grade_id')) { $table->dropConstrainedForeignId('grade_id'); }
            if (Schema::hasColumn('students', 'gender')) { $table->dropColumn('gender'); }
            if (Schema::hasColumn('students', 'last_name')) { $table->dropColumn('last_name'); }
            if (Schema::hasColumn('students', 'first_name')) { $table->dropColumn('first_name'); }
            if (Schema::hasColumn('students', 'uid')) { $table->dropUnique('students_uid_unique'); $table->dropColumn('uid'); }
        });
    }
};
