<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class SampleStudentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Ensure a grade exists (JSS 1)
        $grade = DB::table('grades')->where('name', 'JSS 1')->first();
        if (!$grade) {
            $gradeId = DB::table('grades')->insertGetId([
                'name' => 'JSS 1',
                'display_order' => 11,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        } else {
            $gradeId = $grade->id;
        }

        // Create parent contact
        $parentId = DB::table('parent_contacts')->insertGetId([
            'full_name' => 'Test Parent',
            'whatsapp_number' => '+2348000000000',
            'email' => null,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Fixed QR UID for easy testing
        $qrUid = '11111111-1111-1111-1111-111111111111';
        $uid = '22222222-2222-2222-2222-222222222222';

        // Upsert student by qr_uid
        $existing = DB::table('students')->where('qr_uid', $qrUid)->first();
        if (!$existing) {
            DB::table('students')->insert([
                'uid' => $uid,
                'first_name' => 'Ada',
                'last_name' => 'Okafor',
                'gender' => 'Female',
                'grade_id' => $gradeId,
                'parent_contact_id' => $parentId,
                'qr_uid' => $qrUid,
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
