<?php $__env->startSection('title','Devices'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
  <div class="card-header" style="display:flex; align-items:center; justify-content:space-between; gap:10px; flex-wrap:wrap;">
    <div>Registered Devices</div>
    <form method="POST" action="<?php echo e(route('devices.store')); ?>" style="display:flex; gap:8px; align-items:center;">
      <?php echo csrf_field(); ?>
      <input type="text" name="name" placeholder="Device name (optional)" style="padding:8px 10px; border-radius:8px; border:1px solid #cfd8dc;">
      <button class="btn" type="submit">Register Device</button>
    </form>
  </div>
  <div class="card-body" style="overflow-x:auto;">
    <?php if(session('ok')): ?>
      <div style="margin-bottom:12px; padding:10px 12px; border-radius:10px; background:rgba(13,71,161,0.08); color:#0D47A1;">
        <?php echo e(session('ok')); ?>

      </div>
    <?php endif; ?>
    <?php if(session('new_token')): ?>
      <div style="margin-bottom:12px; padding:10px 12px; border-radius:10px; background:rgba(255,235,59,0.2); color:#795548;">
        <div><strong>New Device Token:</strong> <code><?php echo e(session('new_token')); ?></code></div>
        <div class="muted">Copy now and provide to the gatekeeper app. It will be hashed in storage and not shown again.</div>
      </div>
    <?php endif; ?>

    <?php if($devices->count() === 0): ?>
      <p>No devices found.</p>
    <?php else: ?>
      <table>
        <thead>
          <tr>
            <th>Name</th>
            <th>API Token (hash)</th>
            <th>Last Seen</th>
            <th>Registered</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td><?php echo e($d->name ?? 'Unnamed'); ?></td>
              <td><code><?php echo e(\Illuminate\Support\Str::limit($d->api_token, 16)); ?></code></td>
              <td><?php echo e($d->last_seen_at ? \Carbon\Carbon::parse($d->last_seen_at)->diffForHumans() : '-'); ?></td>
              <td><?php echo e(\Carbon\Carbon::parse($d->created_at)->format('Y-m-d H:i')); ?></td>
              <td>
                <div style="display:flex; gap:8px;">
                  <form method="POST" action="<?php echo e(route('devices.reset_token', $d->id)); ?>" onsubmit="return confirm('Reset this device token?');">
                    <?php echo csrf_field(); ?>
                    <button class="btn" type="submit">Reset Token</button>
                  </form>
                  <form method="POST" action="<?php echo e(route('devices.destroy', $d->id)); ?>" onsubmit="return confirm('Delete this device?');">
                    <?php echo csrf_field(); ?>
                    <button class="btn secondary" type="submit" style="background:#D32F2F;">Delete</button>
                  </form>
                </div>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
      <div style="margin-top:12px;"><?php echo e($devices->links()); ?></div>
    <?php endif; ?>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\TemitopeNejo\OneDrive - Puroclean Home Savers\Documents\Attendance\backend_app\resources\views/devices/index.blade.php ENDPATH**/ ?>