<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>CPS Attendance</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        :root{ --red:#D32F2F; --blue:#0D47A1; --gray:#90A4AE; --white:#FFFFFF; }
        body{ font-family: 'Inter', sans-serif; margin:0; background: linear-gradient(135deg, rgba(13,71,161,0.06), rgba(211,47,47,0.06)); }
        .shell{ display:flex; min-height:100vh; }
        .sidebar{ width:240px; background:rgba(255,255,255,0.6); backdrop-filter: blur(10px); border-right:1px solid rgba(0,0,0,0.06); padding:20px; }
        .brand{ display:flex; align-items:center; gap:10px; }
        .brand img{ height:36px; width:auto; }
        .brand-title{ font-weight:700; color:var(--blue); letter-spacing:0.3px; }
        .nav{ margin-top:24px; display:flex; flex-direction:column; gap:8px; }
        .nav a{ text-decoration:none; color:#044; padding:10px 12px; border-radius:10px; transition:.2s; }
        .nav a:hover{ background: rgba(13,71,161,0.08); }
        .content{ flex:1; display:flex; flex-direction:column; }
        .topbar{ height:60px; display:flex; align-items:center; justify-content:space-between; padding:0 20px; border-bottom:1px solid rgba(0,0,0,0.06); background:rgba(255,255,255,0.7); backdrop-filter: blur(10px); }
        .title{ font-weight:600; color:#102a43; }
        .container{ padding:24px; }
        .card{ background:#fff; border-radius:14px; box-shadow: 0 10px 25px rgba(13,71,161,0.08); border:1px solid rgba(0,0,0,0.06); }
        .card .card-header{ padding:16px 18px; border-bottom:1px solid rgba(0,0,0,0.06); font-weight:600; color:#0D47A1; }
        .card .card-body{ padding:18px; }
        .btn{ display:inline-block; padding:10px 14px; border-radius:10px; background:var(--blue); color:#fff; text-decoration:none; border:none; cursor:pointer; }
        .btn.secondary{ background:var(--red); }
        table{ width:100%; border-collapse:collapse; }
        th,td{ text-align:left; padding:10px 8px; border-bottom:1px solid #eee; }
        th{ color:#0D47A1; }
        .muted{ color:#677; font-size:12px; }
    </style>
</head>
<body>
<div class="shell">
    <aside class="sidebar">
        <div class="brand">
            <img src="/brand/logo" alt="CPS Logo">
            <div class="brand-title">CPS Attendance</div>
        </div>
        <nav class="nav">
            <a href="/" class="<?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>" style="<?php echo e(request()->routeIs('dashboard') ? 'background:rgba(13,71,161,0.12); color:#0D47A1; font-weight:700;' : ''); ?>">Dashboard</a>
            <a href="/students" class="<?php echo e(request()->routeIs('students.*') ? 'active' : ''); ?>" style="<?php echo e(request()->routeIs('students.*') ? 'background:rgba(13,71,161,0.12); color:#0D47A1; font-weight:700;' : ''); ?>">Students</a>
            <a href="/reports" class="<?php echo e(request()->routeIs('reports.*') ? 'active' : ''); ?>" style="<?php echo e(request()->routeIs('reports.*') ? 'background:rgba(13,71,161,0.12); color:#0D47A1; font-weight:700;' : ''); ?>">Reports</a>
            
            <a href="/settings" class="<?php echo e(request()->routeIs('settings.*') ? 'active' : ''); ?>" style="<?php echo e(request()->routeIs('settings.*') ? 'background:rgba(13,71,161,0.12); color:#0D47A1; font-weight:700;' : ''); ?>">Settings</a>
        </nav>
    </aside>
    <main class="content">
        <div class="topbar">
            <div class="title"><?php echo $__env->yieldContent('title','Dashboard'); ?></div>
            <div style="display:flex; align-items:center; gap:16px;">
                <div class="muted">Chalcedony Prime School</div>
                <form method="POST" action="<?php echo e(route('logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <button class="btn secondary" type="submit">Logout</button>
                </form>
            </div>
        </div>
        <div class="container">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </main>
</div>
</body>
</html>
<?php /**PATH C:\Users\TemitopeNejo\OneDrive - Puroclean Home Savers\Documents\Attendance\backend_app\resources\views/layouts/app.blade.php ENDPATH**/ ?>