<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Login - CPS Attendance</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
  <style>
    body{ font-family:'Inter',sans-serif; margin:0; min-height:100vh; display:flex; align-items:center; justify-content:center; background:linear-gradient(135deg, rgba(13,71,161,0.08), rgba(211,47,47,0.08)); }
    .panel{ width:360px; background:rgba(255,255,255,0.7); backdrop-filter: blur(12px); border-radius:14px; box-shadow:0 10px 30px rgba(13,71,161,0.12); border:1px solid rgba(0,0,0,0.06); }
    .panel-header{ padding:20px; display:flex; align-items:center; gap:10px; border-bottom:1px solid rgba(0,0,0,0.06); }
    .panel-header img{ height:36px; }
    .panel-header .title{ font-weight:700; color:#0D47A1; }
    .panel-body{ padding:20px; }
    .field{ margin-bottom:12px; }
    .field label{ display:block; font-size:14px; color:#102a43; margin-bottom:6px; }
    .field input{ width:100%; padding:10px 12px; border-radius:10px; border:1px solid #cfd8dc; outline:none; }
    .btn{ width:100%; padding:10px 14px; border-radius:10px; background:#0D47A1; color:#fff; border:none; cursor:pointer; font-weight:600; }
    .error{ color:#D32F2F; font-size:13px; margin-top:6px; }
  </style>
</head>
<body>
  <div class="panel">
    <div class="panel-header">
      <img src="/assets/brand/logo.png" alt="CPS Logo" />
      <div class="title">CPS Attendance</div>
    </div>
    <div class="panel-body">
      <form method="POST" action="<?php echo e(route('login.post')); ?>">
        <?php echo csrf_field(); ?>
        <div class="field">
          <label>Email</label>
          <input type="email" name="email" value="<?php echo e(old('email', 'admin@cps.local')); ?>" required />
          <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="error"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
        <div class="field">
          <label>Password</label>
          <input type="password" name="password" required />
          <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="error"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
        <div class="field">
          <label><input type="checkbox" name="remember" /> Remember me</label>
        </div>
        <button class="btn" type="submit">Sign in</button>
      </form>
    </div>
  </div>
</body>
</html>
<?php /**PATH /home/routenet/cps/resources/views/auth/login.blade.php ENDPATH**/ ?>