<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('grades', function (Blueprint $table) {
            if (!Schema::hasColumn('grades', 'name')) {
                $table->string('name')->unique();
            }
            if (!Schema::hasColumn('grades', 'display_order')) {
                $table->integer('display_order')->default(0);
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('grades', function (Blueprint $table) {
            if (Schema::hasColumn('grades', 'display_order')) {
                $table->dropColumn('display_order');
            }
            if (Schema::hasColumn('grades', 'name')) {
                $table->dropUnique('grades_name_unique');
                $table->dropColumn('name');
            }
        });
    }
};
