<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('devices', function (Blueprint $table) {
            if (!Schema::hasColumn('devices', 'name')) {
                $table->string('name');
            }
            if (!Schema::hasColumn('devices', 'token')) {
                $table->string('token')->unique();
            }
            if (!Schema::hasColumn('devices', 'status')) {
                $table->string('status')->default('active');
            }
            if (!Schema::hasColumn('devices', 'last_seen_at')) {
                $table->dateTime('last_seen_at')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('devices', function (Blueprint $table) {
            if (Schema::hasColumn('devices', 'last_seen_at')) { $table->dropColumn('last_seen_at'); }
            if (Schema::hasColumn('devices', 'status')) { $table->dropColumn('status'); }
            if (Schema::hasColumn('devices', 'token')) { $table->dropUnique('devices_token_unique'); $table->dropColumn('token'); }
            if (Schema::hasColumn('devices', 'name')) { $table->dropColumn('name'); }
        });
    }
};
