<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class GradesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $grades = [
            'Creche', 'Nursery 1', 'Nursery 2',
            'Primary 1', 'Primary 2', 'Primary 3', 'Primary 4', 'Primary 5', 'Primary 6',
            'JSS 1', 'JSS 2', 'JSS 3',
            'SSS 1', 'SSS 2', 'SSS 3',
        ];

        foreach ($grades as $i => $name) {
            DB::table('grades')->updateOrInsert(
                ['name' => $name],
                [
                    'display_order' => $i + 1,
                    'updated_at' => now(),
                    'created_at' => now(),
                ]
            );
        }
    }
}
