<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SettingsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $defaults = [
            'TIMEZONE' => 'Africa/Lagos',
            'DATE_FORMAT' => 'DD/MM/YYYY',
            'TIME_FORMAT' => 'hh:mm A',
            'SCHOOL_START' => '07:30',
            'SCHOOL_END' => '15:00',
            'GRACE_MINUTES' => '10',
            'SCHOOL_NAME' => 'Chalcedony Prime School',
            'APP_NAME' => 'CPS Attendance',
        ];

        foreach ($defaults as $key => $value) {
            DB::table('settings')->updateOrInsert(
                ['key' => $key],
                ['value' => $value, 'created_at' => now(), 'updated_at' => now()]
            );
        }
    }
}
