@extends('layouts.app')

@section('title','Print QR Codes')

@section('content')
<div class="card">
  <div class="card-header" style="display:flex; align-items:center; justify-content:space-between;">
    <div>QR Codes</div>
    <div>
      <button class="btn" onclick="window.print()">Print</button>
    </div>
  </div>
  <div class="card-body">
    <form method="GET" action="{{ route('students.qr') }}" style="margin-bottom:16px; display:flex; gap:10px; align-items:center; flex-wrap:wrap;">
      <label>Filter by Grade</label>
      <select name="grade_id" style="padding:8px 10px; border-radius:8px; border:1px solid #cfd8dc;">
        <option value="">All Grades</option>
        @foreach ($grades as $g)
          <option value="{{ $g->id }}" {{ (string)$selectedGradeId === (string)$g->id ? 'selected' : '' }}>{{ $g->name }}</option>
        @endforeach
      </select>
      <label style="display:inline-flex; gap:6px; align-items:center;">
        <input type="checkbox" name="group" value="1" {{ $group ? 'checked' : '' }}> Group by grade
      </label>
      <button class="btn" type="submit">Apply</button>
    </form>

    @if ($students->count() === 0)
      <p>No students found for this filter.</p>
    @else
      @if ($group)
        @php $byGrade = collect($students)->groupBy('grade_name'); @endphp
        @foreach ($byGrade as $gradeName => $list)
          <h3 style="margin:12px 0; color:#0D47A1;">{{ $gradeName }}</h3>
          <div class="qr-grid" style="display:grid; grid-template-columns: repeat(3, minmax(0,1fr)); gap:16px;">
            @foreach ($list as $s)
              <div class="qr-card" style="background:#fff; border:1px solid #eee; border-radius:12px; padding:14px; display:flex; gap:12px; align-items:center;">
                <div class="qr-box" id="qr-{{ $loop->parent->index }}-{{ $loop->index }}" data-qr="{{ $s->qr_uid }}" style="width:110px; height:110px; display:flex; align-items:center; justify-content:center; border:1px dashed #ddd; border-radius:10px;"></div>
                <div style="flex:1;">
                  <div style="font-weight:700; color:#0D47A1;">{{ $s->last_name }}, {{ $s->first_name }}</div>
                  <div class="muted">{{ $s->grade_name }}</div>
                  <div class="muted"><code style="font-size:12px;">{{ $s->qr_uid }}</code></div>
                  <div style="margin-top:8px; display:flex; align-items:center; gap:8px;">
                    <img src="/storage/brand/logo.png" alt="Logo" style="height:20px; width:auto;" />
                    <span class="muted">CPS Attendance</span>
                  </div>
                </div>
              </div>
            @endforeach
          </div>
        @endforeach
      @else
        <div class="qr-grid" style="display:grid; grid-template-columns: repeat(3, minmax(0,1fr)); gap:16px;">
          @foreach ($students as $s)
            <div class="qr-card" style="background:#fff; border:1px solid #eee; border-radius:12px; padding:14px; display:flex; gap:12px; align-items:center;">
              <div class="qr-box" id="qr-{{ $loop->index }}" data-qr="{{ $s->qr_uid }}" style="width:110px; height:110px; display:flex; align-items:center; justify-content:center; border:1px dashed #ddd; border-radius:10px;"></div>
              <div style="flex:1;">
                <div style="font-weight:700; color:#0D47A1;">{{ $s->last_name }}, {{ $s->first_name }}</div>
                <div class="muted">{{ $s->grade_name }}</div>
                <div class="muted"><code style="font-size:12px;">{{ $s->qr_uid }}</code></div>
                <div style="margin-top:8px; display:flex; align-items:center; gap:8px;">
                  <img src="/storage/brand/logo.png" alt="Logo" style="height:20px; width:auto;" />
                  <span class="muted">CPS Attendance</span>
                </div>
              </div>
            </div>
          @endforeach
        </div>
      @endif
    @endif
  </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
<script>
  document.addEventListener('DOMContentLoaded', function(){
    function renderQRCodes(){
      if (typeof QRCode === 'undefined') return false;
      document.querySelectorAll('.qr-box').forEach(function(el){
        const val = el.getAttribute('data-qr');
        try {
          new QRCode(el, { text: val, width: 100, height: 100 });
        } catch (e) { console.error('QR render error', e); }
      });
      return true;
    }
    // Try first load
    if (!renderQRCodes()) {
      // Fallback: load from jsDelivr
      var s = document.createElement('script');
      s.src = 'https://cdn.jsdelivr.net/npm/qrcodejs@1.0.0/qrcode.min.js';
      s.onload = renderQRCodes;
      document.body.appendChild(s);
    }
  });
</script>

<style>
  @media print {
    body { background: #fff; }
    .sidebar, .topbar, form, .card-header button { display:none !important; }
    .container { padding:0; }
    .qr-grid { grid-template-columns: repeat(3, minmax(0,1fr)); gap:12px; }
    .qr-card { page-break-inside: avoid; border:1px solid #ccc; }
  }
</style>
@endsection
