<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\StudentsController;
use App\Http\Controllers\SettingsWebController;
use App\Http\Controllers\DashboardController;

// Auth routes
Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.post');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Protected routes
Route::middleware(['auth'])->group(function () {
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/students', [StudentsController::class, 'index'])->name('students.index');
    Route::get('/students/create', [StudentsController::class, 'create'])->name('students.create');
    Route::post('/students', [StudentsController::class, 'store'])->name('students.store');
    Route::get('/students/{id}/edit', [StudentsController::class, 'edit'])->name('students.edit');
    Route::post('/students/{id}', [StudentsController::class, 'update'])->name('students.update');
    Route::get('/students/qr', [StudentsController::class, 'qrPrint'])->name('students.qr');
    Route::get('/students-export', [StudentsController::class, 'exportCsv'])->name('students.export');
    Route::post('/students-import', [StudentsController::class, 'importCsv'])->name('students.import');
    Route::get('/students-import-template', [StudentsController::class, 'csvTemplate'])->name('students.csv_template');
    Route::post('/students/{id}/delete', [StudentsController::class, 'destroy'])->name('students.destroy');
    Route::post('/students/{id}/toggle-status', [StudentsController::class, 'toggleStatus'])->name('students.toggle');
    Route::post('/students/bulk-delete', [StudentsController::class, 'bulkDestroy'])->name('students.bulk_destroy');
    Route::get('/students/undo-delete', [StudentsController::class, 'undoDelete'])->name('students.undo_delete');
    Route::get('/students-export-advanced', [StudentsController::class, 'exportAdvanced'])->name('students.export_advanced');
    Route::post('/students/seed-demo', [StudentsController::class, 'seedDemo'])->name('students.seed_demo');
    
    // Settings (web)
    Route::get('/settings', [SettingsWebController::class, 'index'])->name('settings.index');
    Route::post('/settings', [SettingsWebController::class, 'update'])->name('settings.update');
    Route::post('/settings/test-whatsapp', [SettingsWebController::class, 'testWhatsapp'])->name('settings.test_whatsapp');
    Route::get('/reports', [\App\Http\Controllers\ReportsController::class, 'index'])->name('reports.index');
    Route::get('/reports-export', [\App\Http\Controllers\ReportsController::class, 'exportCsv'])->name('reports.export');

    // Devices management
    Route::get('/devices', [\App\Http\Controllers\DevicesWebController::class, 'index'])->name('devices.index');
    Route::post('/devices', [\App\Http\Controllers\DevicesWebController::class, 'store'])->name('devices.store');
    Route::post('/devices/{id}/reset-token', [\App\Http\Controllers\DevicesWebController::class, 'resetToken'])->name('devices.reset_token');
    Route::post('/devices/{id}/delete', [\App\Http\Controllers\DevicesWebController::class, 'destroy'])->name('devices.destroy');
});

// Public: serve brand logo from storage (fallback, no symlink required)
Route::get('/brand/logo', function(){
    $path = 'brand/logo.png';
    if (Storage::disk('public')->exists($path)) {
        $abs = storage_path('app/public/'.$path);
        return response()->file($abs, [ 'Cache-Control' => 'public, max-age=86400' ]);
    }
    abort(404);
});
